//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Data;
using System.Data.SqlClient;
using System.Diagnostics;

namespace DataBase
{
	/// <summary>
	/// Podsumowanie dla DataBaseMain.
	/// </summary>
	class DataBaseMain
	{
		static void Main(string[] args)
		{
			SqlConnection nwindConn = new SqlConnection("Data Source=mycomputer\\NETSDK;" +
														"Integrated Security=true;" + 
				                                        "Initial Catalog=northwind");
			SqlCommand employeesCommand = new SqlCommand("SELECT EmployeeID, LastName, FirstName, Title FROM Employees", nwindConn);
			try
			{
				nwindConn.Open();
				SqlDataReader myReader = employeesCommand.ExecuteReader();
				DataTable schemaTable = myReader.GetSchemaTable();
				foreach (DataRow myRow in schemaTable.Rows)
				{
					foreach (DataColumn myCol in schemaTable.Columns)
						Console.WriteLine(myCol.ColumnName + " = " + myRow[myCol]);
					Console.WriteLine();
				}
				do
				{
					Console.WriteLine("{0} {1} {2} {3}",
						              myReader.GetName(0),
						              myReader.GetName(1),
						              myReader.GetName(2),
						              myReader.GetName(3));

					while (myReader.Read())
						Console.WriteLine("{0} {1} {2} {3}",
							              myReader.GetInt32(0),
							              myReader.GetString(1),
							              myReader.GetString(2),
							              myReader.GetString(3));

				} while (myReader.NextResult());
				myReader.Close();
				nwindConn.Close();
			}
			catch(Exception e)
			{
				Debug.WriteLine(e);
			}
		}
	}
}
